<?php

namespace App\Http\Controllers\Front;

use App\Models\Category;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class IndexController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;


    public function index($cat=2)
    {
        $allCat=Category::where('parent_id',0)->with('child')->get();
        $cat=Category::where('id',$cat)->with('tutorials')->first();
        return view('front.Index.index')->with('cat',$cat)->with('allCat',$allCat);
    }
}
