<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Log;

class Tutorial extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $guarded = ['id'];


    // public functions

//    ----------------- store tutorial ----------
    public static function saveTutorial($data, $category_id)
    {
        try {
            $new = new self();
            $new->title = $data['title'];
            if (isset($data['image']) and $data['image'] != null)
                $new->img = storeFile($data['image'], 'Upload/tutorials/');
            $new->text = $data['text'];
            $new->category_id = $category_id;
            $new->save();
        } catch (\Exception $e) {
//            Log::channel('')
            dd($e);
        }
    }

}
