<?php



function storeFile($file, $path, $arrResize = null, $private = 0)
{
    $date = \Carbon\Carbon::now();
    $date = \Carbon\Carbon::parse($date)->format('d-m-Y');

    if (!Auth::check())
        $name = $date . '-' . Str::random(32);
    else {
        $user_id = Auth::id();
        $name = $user_id . $date . '-' . Str::random(32) . $user_id;
    }
    $allowedfileExtension = ['jpeg', 'jpg', 'png', 'gif', 'svg', 'pdf', 'xlsx', 'm4v', 'mp4', 'webp', 'WEBP'];
    $ext = $file->getClientOriginalExtension();
    $settingcheck = in_array($ext, $allowedfileExtension);
    $full_name = $name . '.' . $ext;
    $thumbnailpath = '';
    if ($settingcheck) {
        if ($private == 0) {
            $file->move($path, $full_name);
            $full = $path . $full_name;
            $thumbnailpath = $full;
        } else {
            $file->storeAs($path, $full_name);
            $full = $path . '/' . $full_name;
            $thumbnailpath = $full;
        }
    }

    return $thumbnailpath;
}


